/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.client.protocol;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpException;
import ch.boye.httpclientandroidlib.HttpHost;
import ch.boye.httpclientandroidlib.HttpRequest;
import ch.boye.httpclientandroidlib.HttpRequestInterceptor;
import ch.boye.httpclientandroidlib.ProtocolException;
import ch.boye.httpclientandroidlib.androidextra.HttpClientAndroidLog;
import ch.boye.httpclientandroidlib.annotation.Immutable;
import ch.boye.httpclientandroidlib.client.CookieStore;
import ch.boye.httpclientandroidlib.client.methods.HttpUriRequest;
import ch.boye.httpclientandroidlib.client.params.HttpClientParams;
import ch.boye.httpclientandroidlib.conn.HttpRoutedConnection;
import ch.boye.httpclientandroidlib.conn.routing.HttpRoute;
import ch.boye.httpclientandroidlib.cookie.Cookie;
import ch.boye.httpclientandroidlib.cookie.CookieOrigin;
import ch.boye.httpclientandroidlib.cookie.CookieSpec;
import ch.boye.httpclientandroidlib.cookie.CookieSpecRegistry;
import ch.boye.httpclientandroidlib.cookie.SetCookie2;
import ch.boye.httpclientandroidlib.protocol.HttpContext;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Immutable
public class RequestAddCookies
implements HttpRequestInterceptor {
    public HttpClientAndroidLog log = new HttpClientAndroidLog(this.getClass());

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        int ver;
        URI requestURI;
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        CookieStore cookieStore = (CookieStore)context.getAttribute("http.cookie-store");
        if (cookieStore == null) {
            this.log.debug("Cookie store not specified in HTTP context");
            return;
        }
        CookieSpecRegistry registry = (CookieSpecRegistry)context.getAttribute("http.cookiespec-registry");
        if (registry == null) {
            this.log.debug("CookieSpec registry not specified in HTTP context");
            return;
        }
        HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
        if (targetHost == null) {
            this.log.debug("Target host not set in the context");
            return;
        }
        HttpRoutedConnection conn = (HttpRoutedConnection)context.getAttribute("http.connection");
        if (conn == null) {
            this.log.debug("HTTP connection not set in the context");
            return;
        }
        String policy = HttpClientParams.getCookiePolicy(request.getParams());
        if (this.log.isDebugEnabled()) {
            this.log.debug("CookieSpec selected: " + policy);
        }
        if (request instanceof HttpUriRequest) {
            requestURI = ((HttpUriRequest)request).getURI();
        } else {
            try {
                requestURI = new URI(request.getRequestLine().getUri());
            }
            catch (URISyntaxException ex) {
                throw new ProtocolException("Invalid request URI: " + request.getRequestLine().getUri(), ex);
            }
        }
        String hostName = targetHost.getHostName();
        int port = targetHost.getPort();
        if (port < 0) {
            String scheme;
            HttpRoute route = conn.getRoute();
            port = route.getHopCount() == 1 ? conn.getRemotePort() : ((scheme = targetHost.getSchemeName()).equalsIgnoreCase("http") ? 80 : (scheme.equalsIgnoreCase("https") ? 443 : 0));
        }
        CookieOrigin cookieOrigin = new CookieOrigin(hostName, port, requestURI.getPath(), conn.isSecure());
        CookieSpec cookieSpec = registry.getCookieSpec(policy, request.getParams());
        ArrayList<Cookie> cookies = new ArrayList<Cookie>(cookieStore.getCookies());
        ArrayList<Cookie> matchedCookies = new ArrayList<Cookie>();
        Date now = new Date();
        for (Cookie cookie : cookies) {
            if (!cookie.isExpired(now)) {
                if (!cookieSpec.match(cookie, cookieOrigin)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Cookie " + cookie + " match " + cookieOrigin);
                }
                matchedCookies.add(cookie);
                continue;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("Cookie " + cookie + " expired");
        }
        if (!matchedCookies.isEmpty()) {
            List<Header> headers = cookieSpec.formatCookies(matchedCookies);
            for (Header header : headers) {
                request.addHeader(header);
            }
        }
        if ((ver = cookieSpec.getVersion()) > 0) {
            Header header;
            boolean needVersionHeader = false;
            for (Cookie cookie : matchedCookies) {
                if (ver == cookie.getVersion() && cookie instanceof SetCookie2) continue;
                needVersionHeader = true;
            }
            if (needVersionHeader && (header = cookieSpec.getVersionHeader()) != null) {
                request.addHeader(header);
            }
        }
        context.setAttribute("http.cookie-spec", cookieSpec);
        context.setAttribute("http.cookie-origin", cookieOrigin);
    }
}

