/*
 * Decompiled with CFR 0.152.
 */
package cb.jdynamite;

import cb.jdynamite.ITemplateDocument;
import cb.jdynamite.analyser.DefaultAnalyser;
import cb.jdynamite.analyser.DefaultDynamicElement;
import cb.jdynamite.analyser.IDynamicElement;
import cb.jdynamite.analyser.ITemplateAnalyser;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;

public class JDynamiTe
extends DefaultDynamicElement
implements ITemplateDocument,
Serializable {
    private Hashtable variables = new Hashtable();
    private Hashtable dynamics = new Hashtable();
    private ITemplateAnalyser analyser;

    public JDynamiTe() {
        this("__topLevel__");
    }

    public JDynamiTe(String name) {
        super(name);
        this.recordDynElem(name, this);
    }

    public void clearAll() {
        this.clearAllVariables();
        this.clearAllDynElemValues();
    }

    public void clearAllDynElemValues() {
        Collection dynElems = this.dynamics.values();
        Iterator iter = dynElems.iterator();
        while (iter.hasNext()) {
            IDynamicElement dynElem = (IDynamicElement)iter.next();
            dynElem.setValue(null);
        }
    }

    public void clearAllVariables() {
        this.variables.clear();
    }

    public ITemplateAnalyser getAnalyser() {
        return this.analyser;
    }

    public IDynamicElement getDynElem(String key) {
        return (IDynamicElement)this.dynamics.get(key);
    }

    public String getTemplateDefinition() {
        return this.getDefinition(0);
    }

    public String getVariable(String key) {
        return (String)this.variables.get(key);
    }

    private static void justForInternalTest(String[] args) {
        JDynamiTe jDoc = new JDynamiTe("MonDocTemplate");
        try {
            jDoc.setInput("body1.html");
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        String totalDef = jDoc.getDefinition(0);
        System.out.println("\nANALYSE :\n\n" + totalDef + "\n\nFIN ANALYSE\n\n");
        jDoc.setVariable("TITRE", "Test de JDynamiTe");
        int i = 0;
        while (i < 10) {
            jDoc.setVariable("PART1", "ligne_" + i + ",col_1");
            jDoc.setVariable("PART2", "ligne_" + i + ",col_2");
            jDoc.parseDynElem("elem");
            ++i;
        }
        jDoc.setVariable("PICTURE", "images/myPhoto.gif");
        String option = "classic";
        if (option.equals("classic")) {
            jDoc.parseDynElem("pict");
        } else if (option.equals("arbitraire")) {
            jDoc.setDynElemValue("pict", "\nVALEUR ARBITRAIRE !!!\n");
        } else if (option.equals("les deux !")) {
            jDoc.setDynElemValue("pict", "\nVALEUR ARBITRAIRE !!!\n");
            jDoc.parseDynElem("pict");
        }
        int row = 0;
        while (row < 5) {
            jDoc.setDynElemValue("col", "");
            int col = 0;
            while (col < 3) {
                jDoc.setVariable("PARTX", "ligne_" + row + ",col_" + col);
                jDoc.parseDynElem("col");
                ++col;
            }
            jDoc.setDynElemValue("xcl1", "");
            int col2 = 3;
            while (col2 < 5) {
                jDoc.setVariable("XPART1", "ligne_" + row + ",col(y)_" + col2);
                jDoc.parseDynElem("xcl1");
                ++col2;
            }
            jDoc.parseDynElem("row");
            ++row;
        }
        jDoc.parse();
        System.out.println("\njDoc :\n" + jDoc);
        jDoc.clearAllDynElemValues();
        jDoc.parse();
        System.out.println("\njDoc apres clearAllDynElemValues() ET parse() :\n" + jDoc);
        jDoc.clearAllDynElemValues();
        jDoc.clearAllVariables();
        jDoc.parse();
        System.out.println("\njDoc apres clearAllDynElemValues ET clearAllVariables() ET parse() :\n" + jDoc);
        jDoc.clearAll();
        jDoc.setVariable("TITRE", "DEUZE Test de JDynamiTe");
        int i2 = 0;
        while (i2 < 10) {
            jDoc.setVariable("PART1", "DEUZE ligne_" + i2 + ",col_1");
            jDoc.setVariable("PART2", "DEUZE ligne_" + i2 + ",col_2");
            jDoc.parseDynElem("elem");
            ++i2;
        }
        jDoc.setVariable("PICTURE", "DEUZE images/myPhoto.gif");
        option = "classic";
        if (option.equals("classic")) {
            jDoc.parseDynElem("pict");
        } else if (option.equals("arbitraire")) {
            jDoc.setDynElemValue("pict", "DEUZE \nVALEUR ARBITRAIRE !!!\n");
        } else if (option.equals("les deux !")) {
            jDoc.setDynElemValue("pict", "DEUZE \nVALEUR ARBITRAIRE !!!\n");
            jDoc.parseDynElem("pict");
        }
        int row2 = 0;
        while (row2 < 5) {
            jDoc.setDynElemValue("col", "");
            int col = 0;
            while (col < 3) {
                jDoc.setVariable("PARTX", "DEUZE ligne_" + row2 + ",col_" + col);
                jDoc.parseDynElem("col");
                ++col;
            }
            jDoc.setDynElemValue("xcl1", "");
            int col3 = 3;
            while (col3 < 5) {
                jDoc.setVariable("XPART1", "DEUZE ligne_" + row2 + ",col(y)_" + col3);
                jDoc.parseDynElem("xcl1");
                ++col3;
            }
            jDoc.parseDynElem("row");
            ++row2;
        }
        jDoc.parse();
        System.out.println("\njDoc REUTILISE :\n" + jDoc);
    }

    public static void main(String[] args) {
        JDynamiTe dynamiTe = new JDynamiTe("MyTemplateTest");
        try {
            dynamiTe.setInput("testTemplateV1_1.html");
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        dynamiTe.setVariable("THE_TITLE", "\"Java Dynamic Template\" test");
        int i = 0;
        while (i < 6) {
            dynamiTe.setVariable("COL1", "ligne_" + i + ",col_1");
            dynamiTe.setVariable("COL2", "ligne_" + i + ",col_2");
            dynamiTe.parseDynElem("mySimpleRow");
            ++i;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("EEEEEE hh'h'mm'm'ss's'");
        String dateString = formatter.format(new Date());
        dynamiTe.setVariable("A_MESSAGE", "Hello Duke, " + dateString);
        int px = 0;
        while (px < 3) {
            dynamiTe.setVariable("PICTURE", "images/duke" + px + ".gif");
            dynamiTe.parseDynElem("somePictures");
            ++px;
        }
        int row = 0;
        while (row < 5) {
            dynamiTe.setDynElemValue("colX", "");
            int col = 0;
            while (col < 3) {
                dynamiTe.setVariable("VALUE_X", "line_" + row + ",col_" + col);
                dynamiTe.parseDynElem("colX");
                ++col;
            }
            dynamiTe.setDynElemValue("colY", "");
            int col2 = 3;
            while (col2 < 5) {
                dynamiTe.setVariable("VALUE_Y", "line_" + row + ",col(BIS)_" + col2);
                dynamiTe.parseDynElem("colY");
                ++col2;
            }
            dynamiTe.parseDynElem("myBigRow");
            ++row;
        }
        dynamiTe.parse();
        System.out.println(dynamiTe.toString());
    }

    public void parse() {
        this.parse(this);
    }

    public void parseDynElem(String elementName) {
        IDynamicElement dynElem = this.getDynElem(elementName);
        if (dynElem != null) {
            dynElem.parse(this);
        }
    }

    public void recordDynElem(String key, IDynamicElement value) {
        this.dynamics.put(key, value);
    }

    public void setAnalyser(ITemplateAnalyser templateAnalyser) {
        this.analyser = templateAnalyser;
    }

    public void setDynElemValue(String elementName, String value) {
        IDynamicElement dynElem = this.getDynElem(elementName);
        if (dynElem != null) {
            dynElem.setValue(value);
        }
    }

    public void setInput(InputStream istream) throws IOException {
        BufferedReader input = new BufferedReader(new InputStreamReader(istream));
        if (this.analyser == null) {
            this.analyser = new DefaultAnalyser();
        }
        this.analyser.analyse(this, this, input);
    }

    public void setInput(String fileName) throws IOException, FileNotFoundException {
        FileReader fileReader = new FileReader(fileName);
        BufferedReader input = new BufferedReader(fileReader);
        if (this.analyser == null) {
            this.analyser = new DefaultAnalyser();
        }
        this.analyser.analyse(this, this, input);
        fileReader.close();
    }

    public void setVariable(String key, String value) {
        this.variables.put(key, value);
    }

    public String toString() {
        return this.getValue(this);
    }
}

