/*
 * Decompiled with CFR 0.152.
 */
package cb.jdynamite.analyser;

import cb.jdynamite.ITemplateDocument;
import cb.jdynamite.analyser.DefaultDynamicElement;
import cb.jdynamite.analyser.IDynamicElement;
import cb.jdynamite.analyser.ITemplateAnalyser;
import cb.jdynamite.analyser.MixedElement;
import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REMatch;
import java.io.BufferedReader;
import java.io.IOException;

public class DefaultAnalyser
implements ITemplateAnalyser {
    private ITemplateDocument rootDoc;
    private BufferedReader input;
    private RE varRegExp;
    private RE dynBeginRegExp;
    private RE dynEndRegExp;
    private RE ignBeginRegExp;
    private RE ignEndRegExp;
    private boolean debug = false;
    public static String HTML_VARIABLE_TAG = "\\{([\\w._:-]+)\\}";
    public static String HTML_BEGIN_DYNAMIC_TAG = "<!-- *BEGIN *DYNAMIC.*: *([\\w._:-]+) *-->";
    public static String HTML_END_DYNAMIC_TAG = "<!-- *END *DYNAMIC.*-->";
    public static String HTML_BEGIN_IGNORED_TAG = "<!-- *BEGIN *IGNORED.*: *([\\w._:-]+) *-->";
    public static String HTML_END_IGNORED_TAG = "<!-- *END *IGNORED.*-->";
    public static String XML_VARIABLE_TAG = "\\{([\\w._:-]+)\\}";
    public static String XML_BEGIN_DYNAMIC_TAG = "<!-- *BEGIN *DYNAMIC.*: *([\\w._:-]+) *-->";
    public static String XML_END_DYNAMIC_TAG = "<!-- *END *DYNAMIC.*-->";
    public static String SCRIPT_VARIABLE_TAG = "\\$([\\w._:-]+)";
    public static String SCRIPT_BEGIN_DYNAMIC_TAG = "#+ *BEGIN *DYNAMIC.*: *([\\w._:-]+) *";
    public static String SCRIPT_END_DYNAMIC_TAG = "#+ *END *DYNAMIC.*";

    public void DefaultAnalyser() {
    }

    private void addMixed(IDynamicElement dynElem, StringBuffer content) {
        if (content.length() != 0) {
            MixedElement mixedElem = new MixedElement(content.toString());
            content.delete(0, content.length());
            dynElem.addElement(mixedElem);
        }
    }

    public void analyse(ITemplateDocument rootDocument, IDynamicElement rootElem, BufferedReader inputText) throws IOException {
        this.rootDoc = rootDocument;
        this.input = inputText;
        this.initRegExp();
        this.doAnalyse(rootElem, 0);
    }

    protected void doAnalyse(IDynamicElement dynElem, int depth) {
        StringBuffer mixed = new StringBuffer();
        boolean inIgnoredElement = false;
        boolean theEnd = false;
        while (!theEnd) {
            REMatch match;
            String line = null;
            try {
                line = this.input.readLine();
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                break;
            }
            if (line == null) {
                this.addMixed(dynElem, mixed);
                break;
            }
            if (inIgnoredElement) {
                match = this.ignEndRegExp.getMatch((Object)line);
                if (match != null) {
                    inIgnoredElement = false;
                    if (!this.debug) continue;
                    System.err.println("<<End Ignore\n");
                    continue;
                }
                if (!this.debug) continue;
                System.err.println("ignore[" + line + "]\n");
                continue;
            }
            match = this.dynBeginRegExp.getMatch((Object)line);
            if (match != null) {
                this.addMixed(dynElem, mixed);
                String name = match.toString(1);
                if (name == null) {
                    System.err.println("Can not get dynamic element name from this line: " + line);
                    name = "___Undefined Name___";
                }
                DefaultDynamicElement newDyn = new DefaultDynamicElement(name);
                dynElem.addElement(newDyn);
                this.rootDoc.recordDynElem(name, newDyn);
                this.doAnalyse(newDyn, depth + 1);
                continue;
            }
            match = this.dynEndRegExp.getMatch((Object)line);
            if (match != null) {
                this.addMixed(dynElem, mixed);
                theEnd = true;
                continue;
            }
            match = this.ignBeginRegExp.getMatch((Object)line);
            if (match != null) {
                inIgnoredElement = true;
                if (!this.debug) continue;
                System.err.println("Begin Ignore>>\n");
                continue;
            }
            mixed.append(String.valueOf(line) + '\n');
        }
    }

    public boolean getDebug() {
        return this.debug;
    }

    public RE getDynamicBeginRegExp() {
        return this.dynBeginRegExp;
    }

    public RE getDynamicEndRegExp() {
        return this.dynEndRegExp;
    }

    public RE getIgnoredBeginRegExp() {
        return this.ignBeginRegExp;
    }

    public RE getIgnoredEndRegExp() {
        return this.ignEndRegExp;
    }

    public RE getVariableRegExp() {
        return this.varRegExp;
    }

    private void initRegExp() {
        this.varRegExp = null;
        this.dynBeginRegExp = null;
        this.dynEndRegExp = null;
        this.ignBeginRegExp = null;
        this.ignEndRegExp = null;
        try {
            this.setVariableRegExp(HTML_VARIABLE_TAG);
            this.setDynamicBeginRegExp(HTML_BEGIN_DYNAMIC_TAG);
            this.setDynamicEndRegExp(HTML_END_DYNAMIC_TAG);
            this.setIgnoredBeginRegExp(HTML_BEGIN_IGNORED_TAG);
            this.setIgnoredEndRegExp(HTML_END_IGNORED_TAG);
        }
        catch (REException e) {
            e.printStackTrace();
        }
    }

    public void setDebug(boolean debugMode) {
        this.debug = debugMode;
    }

    public void setDynamicBeginRegExp(String dynamicBeginRegExp) throws REException {
        this.dynBeginRegExp = new RE((Object)dynamicBeginRegExp);
    }

    public void setDynamicEndRegExp(String dynamicEndRegExp) throws REException {
        this.dynEndRegExp = new RE((Object)dynamicEndRegExp);
    }

    public void setIgnoredBeginRegExp(String ignoredBeginRegExp) throws REException {
        this.ignBeginRegExp = new RE((Object)ignoredBeginRegExp);
    }

    public void setIgnoredEndRegExp(String ignoredEndRegExp) throws REException {
        this.ignEndRegExp = new RE((Object)ignoredEndRegExp);
    }

    public void setVariableRegExp(String variableRegExp) throws REException {
        this.varRegExp = new RE((Object)variableRegExp);
    }
}

