/*
 * Decompiled with CFR 0.152.
 */
package cb.jdynamite.analyser;

import cb.jdynamite.ITemplateDocument;
import cb.jdynamite.analyser.IDynamicElement;
import cb.jdynamite.analyser.ITemplateElement;
import java.util.ArrayList;

public class DefaultDynamicElement
implements ITemplateElement,
IDynamicElement {
    private StringBuffer value;
    private ArrayList templateDef = new ArrayList();
    private String name;

    public DefaultDynamicElement() {
        this.value = new StringBuffer();
    }

    public DefaultDynamicElement(String elementName) {
        this();
        this.name = elementName;
    }

    public void addElement(ITemplateElement templateElement) {
        this.templateDef.add(templateElement);
    }

    public String getDefinition(int depth) {
        StringBuffer def = new StringBuffer();
        int indent = 0;
        while (indent < depth) {
            def.append("   ");
            ++indent;
        }
        def.append("DefaultDynamicElement \"" + this.name + "\":\n");
        int elemNb = this.templateDef.size();
        int i = 0;
        while (i < elemNb) {
            ITemplateElement elem = (ITemplateElement)this.templateDef.get(i);
            def.append(elem.getDefinition(depth + 1));
            ++i;
        }
        return def.toString();
    }

    public String getValue(ITemplateDocument rootDocument) {
        return this.value.toString();
    }

    public void parse(ITemplateDocument rootDocument) {
        int elemNb = this.templateDef.size();
        int i = 0;
        while (i < elemNb) {
            ITemplateElement elem = (ITemplateElement)this.templateDef.get(i);
            this.value.append(elem.getValue(rootDocument));
            ++i;
        }
    }

    public void setValue(String arbitraryValue) {
        this.value.delete(0, this.value.length());
        if (arbitraryValue != null) {
            this.value.append(arbitraryValue);
        }
    }
}

