/*
 * Decompiled with CFR 0.152.
 */
package cb.jdynamite.analyser;

import cb.jdynamite.ITemplateDocument;
import cb.jdynamite.analyser.ITemplateElement;
import gnu.regexp.RE;
import gnu.regexp.REMatch;
import gnu.regexp.REMatchEnumeration;

public class MixedElement
implements ITemplateElement {
    private String definition;

    public MixedElement(String content) {
        this.definition = content;
    }

    public String getDefinition(int depth) {
        StringBuffer def = new StringBuffer();
        int indent = 0;
        while (indent < depth) {
            def.append("   ");
            ++indent;
        }
        def.append("MixedElement: ");
        def.append(this.definition.replace('\n', ' '));
        def.append('\n');
        return def.toString();
    }

    public String getValue(ITemplateDocument rootDocument) {
        RE varRegExp = rootDocument.getAnalyser().getVariableRegExp();
        REMatchEnumeration matchEnum = varRegExp.getMatchEnumeration((Object)this.definition);
        if (!matchEnum.hasMoreElements()) {
            return this.definition;
        }
        StringBuffer result = new StringBuffer();
        int constantStart = 0;
        while (matchEnum.hasMoreElements()) {
            REMatch match = matchEnum.nextMatch();
            int matchLength = match.getEndIndex() - match.getStartIndex();
            String key = match.toString().substring(1, matchLength - 1);
            result.append(this.definition.substring(constantStart, match.getStartIndex()));
            String variable = rootDocument.getVariable(key);
            if (variable == null) {
                variable = match.toString();
                System.err.println("Warning : no value set for \"" + match + "\" variable !");
            }
            result.append(variable);
            constantStart = match.getEndIndex();
        }
        result.append(this.definition.substring(constantStart));
        return result.toString();
    }
}

