/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.elements;

import java.awt.Color;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import rst.pdfbox.layout.elements.Cutter;
import rst.pdfbox.layout.elements.Dividable;
import rst.pdfbox.layout.elements.Drawable;
import rst.pdfbox.layout.elements.Element;
import rst.pdfbox.layout.elements.VerticalSpacer;
import rst.pdfbox.layout.shape.Rect;
import rst.pdfbox.layout.shape.Shape;
import rst.pdfbox.layout.shape.Stroke;
import rst.pdfbox.layout.text.DrawListener;
import rst.pdfbox.layout.text.Position;
import rst.pdfbox.layout.text.WidthRespecting;

public class Frame
implements Element,
Drawable,
WidthRespecting,
Dividable {
    private List<Drawable> innerList = new CopyOnWriteArrayList<Drawable>();
    private float paddingLeft;
    private float paddingRight;
    private float paddingTop;
    private float paddingBottom;
    private float marginLeft;
    private float marginRight;
    private float marginTop;
    private float marginBottom;
    private Shape shape = new Rect();
    private Stroke borderStroke = new Stroke();
    private Color borderColor;
    private Color backgroundColor;
    private float maxWidth = -1.0f;
    private Float givenWidth;
    private Float givenHeight;
    private Position absolutePosition;

    public Frame() {
        this(null, null);
    }

    public Frame(Drawable inner) {
        this(inner, null, null);
    }

    public Frame(Drawable inner, Float width, Float height) {
        this(width, height);
        this.add(inner);
    }

    public Frame(Float width, Float height) {
        this.givenWidth = width;
        this.givenHeight = height;
    }

    public void add(Drawable drawable) {
        this.innerList.add(drawable);
    }

    protected void addAll(Collection<Drawable> drawable) {
        this.innerList.addAll(drawable);
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public Stroke getBorderStroke() {
        return this.borderStroke;
    }

    public void setBorderStroke(Stroke borderStroke) {
        this.borderStroke = borderStroke;
    }

    protected float getBorderWidth() {
        return this.hasBorder() ? this.getBorderStroke().getLineWidth() : 0.0f;
    }

    protected boolean hasBorder() {
        return this.getShape() != null && this.getBorderStroke() != null && this.getBorderColor() != null;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public void setBorder(Color borderColor, Stroke borderStroke) {
        this.setBorderColor(borderColor);
        this.setBorderStroke(borderStroke);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    protected void copyAllButInnerAndSizeTo(Frame other) {
        other.setShape(this.getShape());
        other.setBorderStroke(this.getBorderStroke());
        other.setBorderColor(this.getBorderColor());
        other.setBackgroundColor(this.getBackgroundColor());
        other.setPaddingBottom(this.getPaddingBottom());
        other.setPaddingLeft(this.getPaddingLeft());
        other.setPaddingRight(this.getPaddingRight());
        other.setPaddingTop(this.getPaddingTop());
        other.setMarginBottom(this.getMarginBottom());
        other.setMarginLeft(this.getMarginLeft());
        other.setMarginRight(this.getMarginRight());
        other.setMarginTop(this.getMarginTop());
    }

    public float getPaddingLeft() {
        return this.paddingLeft;
    }

    public void setPaddingLeft(float paddingLeft) {
        this.paddingLeft = paddingLeft;
    }

    public float getPaddingRight() {
        return this.paddingRight;
    }

    public void setPaddingRight(float paddingRight) {
        this.paddingRight = paddingRight;
    }

    public float getPaddingTop() {
        return this.paddingTop;
    }

    public void setPaddingTop(float paddingTop) {
        this.paddingTop = paddingTop;
    }

    public float getPaddingBottom() {
        return this.paddingBottom;
    }

    public void setPaddingBottom(float paddingBottom) {
        this.paddingBottom = paddingBottom;
    }

    public void setPadding(float left, float right, float top, float bottom) {
        this.setPaddingLeft(left);
        this.setPaddingRight(right);
        this.setPaddingTop(top);
        this.setPaddingBottom(bottom);
    }

    public float getMarginLeft() {
        return this.marginLeft;
    }

    public void setMarginLeft(float marginLeft) {
        this.marginLeft = marginLeft;
    }

    public float getMarginRight() {
        return this.marginRight;
    }

    public void setMarginRight(float marginRight) {
        this.marginRight = marginRight;
    }

    public float getMarginTop() {
        return this.marginTop;
    }

    public void setMarginTop(float marginTop) {
        this.marginTop = marginTop;
    }

    public float getMarginBottom() {
        return this.marginBottom;
    }

    public void setMarginBottom(float marginBottom) {
        this.marginBottom = marginBottom;
    }

    public void setMargin(float left, float right, float top, float bottom) {
        this.setMarginLeft(left);
        this.setMarginRight(right);
        this.setMarginTop(top);
        this.setMarginBottom(bottom);
    }

    protected float getHorizontalShapeSpacing() {
        return 2.0f * this.getBorderWidth() + this.getPaddingLeft() + this.getPaddingRight();
    }

    protected float getVerticalShapeSpacing() {
        return 2.0f * this.getBorderWidth() + this.getPaddingTop() + this.getPaddingBottom();
    }

    protected float getHorizontalSpacing() {
        return this.getMarginLeft() + this.getMarginRight() + this.getHorizontalShapeSpacing();
    }

    protected float getVerticalSpacing() {
        return this.getMarginTop() + this.getMarginBottom() + this.getVerticalShapeSpacing();
    }

    protected Float getGivenHeight() {
        return this.givenHeight;
    }

    protected Float getGivenWidth() {
        return this.givenWidth;
    }

    @Override
    public float getWidth() throws IOException {
        if (this.getGivenWidth() != null) {
            return this.getGivenWidth().floatValue() + this.getMarginLeft() + this.getMarginRight();
        }
        return this.getMaxWidth(this.innerList) + this.getHorizontalSpacing();
    }

    protected float getMaxWidth(List<Drawable> drawableList) throws IOException {
        float max = 0.0f;
        if (drawableList != null) {
            for (Drawable inner : drawableList) {
                max = Math.max(max, inner.getWidth());
            }
        }
        return max;
    }

    @Override
    public float getHeight() throws IOException {
        if (this.getGivenHeight() != null) {
            return this.getGivenHeight().floatValue() + this.getMarginTop() + this.getMarginBottom();
        }
        return this.getHeight(this.innerList) + this.getVerticalSpacing();
    }

    protected float getHeight(List<Drawable> drawableList) throws IOException {
        float height = 0.0f;
        if (drawableList != null) {
            for (Drawable inner : drawableList) {
                height += inner.getHeight();
            }
        }
        return height;
    }

    @Override
    public Position getAbsolutePosition() throws IOException {
        return this.absolutePosition;
    }

    public void setAbsolutePosition(Position absolutePosition) {
        this.absolutePosition = absolutePosition;
    }

    @Override
    public float getMaxWidth() {
        return this.maxWidth;
    }

    @Override
    public void setMaxWidth(float maxWidth) {
        this.maxWidth = maxWidth;
        for (Drawable inner : this.innerList) {
            this.setMaxWidth(inner, maxWidth);
        }
    }

    private void setMaxWidth(Drawable inner, float maxWidth) {
        if (inner instanceof WidthRespecting) {
            if (this.getGivenWidth() != null) {
                ((WidthRespecting)((Object)inner)).setMaxWidth(this.getGivenWidth().floatValue() - this.getHorizontalShapeSpacing());
            } else if (maxWidth >= 0.0f) {
                ((WidthRespecting)((Object)inner)).setMaxWidth(maxWidth - this.getHorizontalSpacing());
            }
        }
    }

    protected void setInnerMaxWidthIfNecessary() throws IOException {
        if (this.getAbsolutePosition() == null && this.getGivenWidth() != null) {
            this.setMaxWidth(this.getGivenWidth().floatValue() - this.getHorizontalShapeSpacing());
        }
    }

    @Override
    public void draw(PDDocument pdDocument, PDPageContentStream contentStream, Position upperLeft, DrawListener drawListener) throws IOException {
        this.setInnerMaxWidthIfNecessary();
        float halfBorderWidth = 0.0f;
        if (this.getBorderWidth() > 0.0f) {
            halfBorderWidth = this.getBorderWidth() / 2.0f;
        }
        upperLeft = upperLeft.add(this.getMarginLeft() + halfBorderWidth, -this.getMarginTop() - halfBorderWidth);
        if (this.getShape() != null) {
            float shapeWidth = this.getWidth() - this.getMarginLeft() - this.getMarginRight() - this.getBorderWidth();
            float shapeHeight = this.getHeight() - this.getMarginTop() - this.getMarginBottom() - this.getBorderWidth();
            if (this.getBackgroundColor() != null) {
                this.getShape().fill(pdDocument, contentStream, upperLeft, shapeWidth, shapeHeight, this.getBackgroundColor(), drawListener);
            }
            if (this.hasBorder()) {
                this.getShape().draw(pdDocument, contentStream, upperLeft, shapeWidth, shapeHeight, this.getBorderColor(), this.getBorderStroke(), drawListener);
            }
        }
        Position innerUpperLeft = upperLeft.add(this.getPaddingLeft() + halfBorderWidth, -this.getPaddingTop() - halfBorderWidth);
        for (Drawable inner : this.innerList) {
            inner.draw(pdDocument, contentStream, innerUpperLeft, drawListener);
            innerUpperLeft = innerUpperLeft.add(0.0f, -inner.getHeight());
        }
    }

    @Override
    public Drawable removeLeadingEmptyVerticalSpace() throws IOException {
        if (this.innerList.size() > 0) {
            Drawable drawableWithoutLeadingVerticalSpace = this.innerList.get(0).removeLeadingEmptyVerticalSpace();
            this.innerList.set(0, drawableWithoutLeadingVerticalSpace);
        }
        return this;
    }

    @Override
    public Dividable.Divided divide(float remainingHeight, float nextPageHeight) throws IOException {
        this.setInnerMaxWidthIfNecessary();
        if (remainingHeight - this.getVerticalSpacing() <= 0.0f) {
            return new Dividable.Divided(new VerticalSpacer(remainingHeight), this);
        }
        float spaceLeft = remainingHeight - this.getVerticalSpacing();
        DividedList dividedList = this.divideList(this.innerList, spaceLeft);
        float spaceLeftForDivided = spaceLeft - this.getHeight(dividedList.getHead());
        Dividable.Divided divided = null;
        if (dividedList.getDrawableToDivide() != null) {
            Dividable innerDividable = null;
            innerDividable = dividedList.getDrawableToDivide() instanceof Dividable ? (Dividable)((Object)dividedList.getDrawableToDivide()) : new Cutter(dividedList.getDrawableToDivide());
            divided = innerDividable.divide(spaceLeftForDivided, nextPageHeight - this.getVerticalSpacing());
        }
        Float firstHeight = this.getGivenHeight() == null ? null : Float.valueOf(remainingHeight);
        Float tailHeight = this.getGivenHeight() == null ? null : Float.valueOf(this.getGivenHeight().floatValue() - spaceLeft);
        Frame first = new Frame(this.getGivenWidth(), firstHeight);
        this.copyAllButInnerAndSizeTo(first);
        if (dividedList.getHead() != null) {
            first.addAll(dividedList.getHead());
        }
        if (divided != null) {
            first.add(divided.getFirst());
        }
        Frame tail = new Frame(this.getGivenWidth(), tailHeight);
        this.copyAllButInnerAndSizeTo(tail);
        if (divided != null) {
            tail.add(divided.getTail());
        }
        if (dividedList.getTail() != null) {
            tail.addAll(dividedList.getTail());
        }
        return new Dividable.Divided(first, tail);
    }

    private DividedList divideList(List<Drawable> items, float spaceLeft) throws IOException {
        List<Drawable> head = null;
        List<Drawable> tail = null;
        Drawable toDivide = null;
        float tmpHeight = 0.0f;
        int index = 0;
        while (tmpHeight < spaceLeft) {
            if ((tmpHeight += items.get(index).getHeight()) == spaceLeft) {
                head = items.subList(0, index + 1);
                if (index + 1 < items.size()) {
                    tail = items.subList(index + 1, items.size());
                }
            }
            if (tmpHeight > spaceLeft) {
                head = items.subList(0, index);
                toDivide = items.get(index);
                if (index + 1 < items.size()) {
                    tail = items.subList(index + 1, items.size());
                }
            }
            ++index;
        }
        return new DividedList(head, toDivide, tail);
    }

    public static class DividedList {
        private List<Drawable> head;
        private Drawable drawableToDivide;
        private List<Drawable> tail;

        public DividedList(List<Drawable> head, Drawable drawableToDivide, List<Drawable> tail) {
            this.head = head;
            this.drawableToDivide = drawableToDivide;
            this.tail = tail;
        }

        public List<Drawable> getHead() {
            return this.head;
        }

        public Drawable getDrawableToDivide() {
            return this.drawableToDivide;
        }

        public List<Drawable> getTail() {
            return this.tail;
        }
    }
}

