/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.elements.render;

import java.io.IOException;
import rst.pdfbox.layout.elements.ControlElement;
import rst.pdfbox.layout.elements.Drawable;
import rst.pdfbox.layout.elements.Element;
import rst.pdfbox.layout.elements.render.LayoutHint;
import rst.pdfbox.layout.elements.render.RenderContext;
import rst.pdfbox.layout.elements.render.VerticalLayout;

public class ColumnLayout
extends VerticalLayout {
    public static final ControlElement NEWCOLUMN = new ControlElement("NEWCOLUMN");
    private final int columnCount;
    private float columnSpacing;
    private int columnIndex = 0;
    private Float offsetY = null;

    public ColumnLayout(int columnCount) {
        this(columnCount, 0.0f);
    }

    public ColumnLayout(int columnCount, float columnSpacing) {
        this.columnCount = columnCount;
        this.columnSpacing = columnSpacing;
    }

    @Override
    protected float getTargetWidth(RenderContext renderContext) {
        return (renderContext.getWidth() - (float)(this.columnCount - 1) * this.columnSpacing) / (float)this.columnCount;
    }

    @Override
    protected void turnPage(RenderContext renderContext) throws IOException {
        if (++this.columnIndex >= this.columnCount) {
            renderContext.newPage();
            this.columnIndex = 0;
            this.offsetY = Float.valueOf(0.0f);
        } else {
            float nextColumnX = (this.getTargetWidth(renderContext) + this.columnSpacing) * (float)this.columnIndex;
            renderContext.resetPositionToUpperLeft();
            renderContext.movePositionBy(nextColumnX, -this.offsetY.floatValue());
        }
    }

    @Override
    public boolean render(RenderContext renderContext, Element element, LayoutHint layoutHint) throws IOException {
        if (element == ControlElement.NEWPAGE) {
            renderContext.newPage();
            return true;
        }
        if (element == NEWCOLUMN) {
            this.turnPage(renderContext);
            return true;
        }
        return super.render(renderContext, element, layoutHint);
    }

    @Override
    public void render(RenderContext renderContext, Drawable drawable, LayoutHint layoutHint) throws IOException {
        if (this.offsetY == null) {
            this.offsetY = Float.valueOf(renderContext.getUpperLeft().getY() - renderContext.getCurrentPosition().getY());
        }
        super.render(renderContext, drawable, layoutHint);
    }

    @Override
    protected boolean isPositionTopOfPage(RenderContext renderContext) {
        float topPosition = renderContext.getUpperLeft().getY();
        if (this.offsetY != null) {
            topPosition -= this.offsetY.floatValue();
        }
        return renderContext.getCurrentPosition().getY() == topPosition;
    }
}

