/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.elements.render;

import java.io.Closeable;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import rst.pdfbox.layout.elements.ControlElement;
import rst.pdfbox.layout.elements.Document;
import rst.pdfbox.layout.elements.Element;
import rst.pdfbox.layout.elements.Orientation;
import rst.pdfbox.layout.elements.PageFormat;
import rst.pdfbox.layout.elements.PositionControl;
import rst.pdfbox.layout.elements.render.Layout;
import rst.pdfbox.layout.elements.render.LayoutHint;
import rst.pdfbox.layout.elements.render.Renderer;
import rst.pdfbox.layout.elements.render.VerticalLayout;
import rst.pdfbox.layout.text.DrawContext;
import rst.pdfbox.layout.text.DrawListener;
import rst.pdfbox.layout.text.Position;
import rst.pdfbox.layout.text.annotations.AnnotationDrawListener;
import rst.pdfbox.layout.util.CompatibilityHelper;

public class RenderContext
implements Renderer,
Closeable,
DrawContext,
DrawListener {
    private final Document document;
    private final PDDocument pdDocument;
    private PDPage page;
    private int pageIndex = 0;
    private PDPageContentStream contentStream;
    private Position currentPosition;
    private Position markedPosition;
    private Position maxPositionOnPage;
    private Layout layout = new VerticalLayout();
    private PageFormat nextPageFormat;
    private PageFormat pageFormat;
    private AnnotationDrawListener annotationDrawListener;

    public RenderContext(Document document, PDDocument pdDocument) throws IOException {
        this.document = document;
        this.pdDocument = pdDocument;
        this.pageFormat = document.getPageFormat();
        this.annotationDrawListener = new AnnotationDrawListener(this);
        this.newPage();
    }

    public Layout getLayout() {
        return this.layout;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
        this.resetPositionToLeftEndOfPage();
    }

    @Deprecated
    public Orientation getOrientation() {
        return this.getPageFormat().getOrientation();
    }

    @Deprecated
    public PDRectangle getMediaBox() {
        return this.getPageFormat().getMediaBox();
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.pageFormat = pageFormat == null ? this.document.getPageFormat() : pageFormat;
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public Position getUpperLeft() {
        return new Position(this.getPageFormat().getMarginLeft(), this.getPageHeight() - this.getPageFormat().getMarginTop());
    }

    public Position getLowerRight() {
        return new Position(this.getPageWidth() - this.getPageFormat().getMarginRight(), this.getPageFormat().getMarginBottom());
    }

    public Position getCurrentPosition() {
        return this.currentPosition;
    }

    public Position getMarkedPosition() {
        return this.markedPosition;
    }

    protected void setMarkedPosition(Position markedPosition) {
        this.markedPosition = markedPosition;
    }

    public void movePositionBy(float x, float y) {
        this.currentPosition = this.currentPosition.add(x, y);
    }

    public void resetPositionToUpperLeft() {
        this.currentPosition = this.getUpperLeft();
    }

    public void resetPositionToLeft() {
        this.currentPosition = new Position(this.getUpperLeft().getX(), this.currentPosition.getY());
    }

    protected void resetPositionToLeftEndOfPage() {
        this.currentPosition = new Position(this.getUpperLeft().getX(), this.getMaxPositionOnPage().getY());
    }

    protected Orientation getPageOrientation() {
        if (this.getPageWidth() > this.getPageHeight()) {
            return Orientation.Landscape;
        }
        return Orientation.Portrait;
    }

    public boolean isPageTilted() {
        return CompatibilityHelper.getPageRotation(this.page) == 90 || CompatibilityHelper.getPageRotation(this.page) == 270;
    }

    public float getPageWidth() {
        if (this.isPageTilted()) {
            return this.page.getMediaBox().getHeight();
        }
        return this.page.getMediaBox().getWidth();
    }

    public float getPageHeight() {
        if (this.isPageTilted()) {
            return this.page.getMediaBox().getWidth();
        }
        return this.page.getMediaBox().getHeight();
    }

    public float getWidth() {
        return this.getPageWidth() - this.getPageFormat().getMarginLeft() - this.getPageFormat().getMarginRight();
    }

    public float getHeight() {
        return this.getPageHeight() - this.getPageFormat().getMarginTop() - this.getPageFormat().getMarginBottom();
    }

    public float getRemainingHeight() {
        return this.getCurrentPosition().getY() - this.getPageFormat().getMarginBottom();
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    public PDDocument getPdDocument() {
        return this.pdDocument;
    }

    @Override
    public PDPage getCurrentPage() {
        return this.page;
    }

    @Override
    public PDPageContentStream getCurrentPageContentStream() {
        return this.getContentStream();
    }

    @Deprecated
    public PDPage getPage() {
        return this.getCurrentPage();
    }

    public PDPageContentStream getContentStream() {
        return this.contentStream;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    @Override
    public boolean render(RenderContext renderContext, Element element, LayoutHint layoutHint) throws IOException {
        boolean success = this.getLayout().render(renderContext, element, layoutHint);
        if (success) {
            return true;
        }
        if (element == ControlElement.NEWPAGE) {
            this.newPage();
            return true;
        }
        if (element instanceof PositionControl) {
            return this.render((PositionControl)element);
        }
        if (element instanceof PageFormat) {
            this.nextPageFormat = (PageFormat)element;
            return true;
        }
        if (element instanceof Layout) {
            this.setLayout((Layout)element);
            return true;
        }
        return false;
    }

    protected boolean render(PositionControl positionControl) {
        if (positionControl instanceof PositionControl.MarkPosition) {
            this.setMarkedPosition(this.getCurrentPosition());
            return true;
        }
        if (positionControl instanceof PositionControl.SetPosition) {
            Position newPosition;
            Float y;
            PositionControl.SetPosition setPosition = (PositionControl.SetPosition)positionControl;
            Float x = setPosition.getX();
            if (x == PositionControl.MARKED_POSITION) {
                x = Float.valueOf(this.getMarkedPosition().getX());
            }
            if (x == null) {
                x = Float.valueOf(this.getCurrentPosition().getX());
            }
            if ((y = setPosition.getY()) == PositionControl.MARKED_POSITION) {
                y = Float.valueOf(this.getMarkedPosition().getY());
            }
            if (y == null) {
                y = Float.valueOf(this.getCurrentPosition().getY());
            }
            this.currentPosition = newPosition = new Position(x.floatValue(), y.floatValue());
            return true;
        }
        if (positionControl instanceof PositionControl.MovePosition) {
            PositionControl.MovePosition movePosition = (PositionControl.MovePosition)positionControl;
            this.movePositionBy(movePosition.getX(), movePosition.getY());
            return true;
        }
        return false;
    }

    public void newPage() throws IOException {
        if (this.closePage()) {
            ++this.pageIndex;
        }
        if (this.nextPageFormat != null) {
            this.setPageFormat(this.nextPageFormat);
        }
        this.page = new PDPage(this.getPageFormat().getMediaBox());
        this.pdDocument.addPage(this.page);
        this.contentStream = CompatibilityHelper.createAppendablePDPageContentStream(this.pdDocument, this.page);
        if (this.getPageOrientation() != this.getPageFormat().getOrientation()) {
            if (this.isPageTilted()) {
                this.page.setRotation(0);
            } else {
                this.page.setRotation(90);
            }
        }
        if (this.isPageTilted()) {
            CompatibilityHelper.transform(this.contentStream, 0.0f, 1.0f, -1.0f, 0.0f, this.getPageHeight(), 0.0f);
        }
        this.resetPositionToUpperLeft();
        this.resetMaxPositionOnPage();
        this.document.beforePage(this);
        this.annotationDrawListener.beforePage(this);
    }

    public boolean closePage() throws IOException {
        if (this.contentStream != null) {
            this.annotationDrawListener.afterPage(this);
            this.document.afterPage(this);
            if (this.getPageFormat().getRotation() != 0) {
                int currentRotation = CompatibilityHelper.getPageRotation(this.getCurrentPage());
                this.getCurrentPage().setRotation(currentRotation + this.getPageFormat().getRotation());
            }
            this.contentStream.close();
            this.contentStream = null;
            return true;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        this.closePage();
        this.annotationDrawListener.afterRender();
    }

    @Override
    public void drawn(Object drawnObject, Position upperLeft, float width, float height) {
        this.updateMaxPositionOnPage(upperLeft, width, height);
        this.annotationDrawListener.drawn(drawnObject, upperLeft, width, height);
    }

    protected void updateMaxPositionOnPage(Position upperLeft, float width, float height) {
        this.maxPositionOnPage = new Position(Math.max(this.maxPositionOnPage.getX(), upperLeft.getX() + width), Math.min(this.maxPositionOnPage.getY(), upperLeft.getY() - height));
    }

    protected void resetMaxPositionOnPage() {
        this.maxPositionOnPage = this.getUpperLeft();
    }

    protected Position getMaxPositionOnPage() {
        return this.maxPositionOnPage;
    }
}

