/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.text;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import rst.pdfbox.layout.text.Alignment;
import rst.pdfbox.layout.text.DrawListener;
import rst.pdfbox.layout.text.FontDescriptor;
import rst.pdfbox.layout.text.NewLine;
import rst.pdfbox.layout.text.Position;
import rst.pdfbox.layout.text.StyledText;
import rst.pdfbox.layout.text.TextFragment;
import rst.pdfbox.layout.text.TextSequence;
import rst.pdfbox.layout.text.TextSequenceUtil;
import rst.pdfbox.layout.text.WrappingNewLine;
import rst.pdfbox.layout.util.CompatibilityHelper;

public class TextLine
implements TextSequence {
    private static final String ASCENT = "ascent";
    private static final String HEIGHT = "height";
    private static final String WIDTH = "width";
    private final List<StyledText> styledTextList = new ArrayList<StyledText>();
    private NewLine newLine;
    private Map<String, Object> cache = new HashMap<String, Object>();

    private void clearCache() {
        this.cache.clear();
    }

    private void setCachedValue(String key, Object value) {
        this.cache.put(key, value);
    }

    private <T> T getCachedValue(String key, Class<T> type) {
        return (T)this.cache.get(key);
    }

    public void add(StyledText fragment) {
        this.styledTextList.add(fragment);
        this.clearCache();
    }

    public void add(TextLine textLine) {
        for (StyledText fragment : textLine.getStyledTexts()) {
            this.add(fragment);
        }
    }

    public NewLine getNewLine() {
        return this.newLine;
    }

    public void setNewLine(NewLine newLine) {
        this.newLine = newLine;
        this.clearCache();
    }

    public List<StyledText> getStyledTexts() {
        return Collections.unmodifiableList(this.styledTextList);
    }

    @Override
    public Iterator<TextFragment> iterator() {
        return new TextLineIterator(this.styledTextList.iterator(), this.newLine);
    }

    public boolean isEmpty() {
        return this.styledTextList.isEmpty() && this.newLine == null;
    }

    @Override
    public float getWidth() throws IOException {
        Float width = this.getCachedValue(WIDTH, Float.class);
        if (width == null) {
            width = Float.valueOf(0.0f);
            for (TextFragment fragment : this) {
                width = Float.valueOf(width.floatValue() + fragment.getWidth());
            }
            this.setCachedValue(WIDTH, width);
        }
        return width.floatValue();
    }

    @Override
    public float getHeight() throws IOException {
        Float height = this.getCachedValue(HEIGHT, Float.class);
        if (height == null) {
            height = Float.valueOf(0.0f);
            for (TextFragment fragment : this) {
                height = Float.valueOf(Math.max(height.floatValue(), fragment.getHeight()));
            }
            this.setCachedValue(HEIGHT, height);
        }
        return height.floatValue();
    }

    protected float getAscent() throws IOException {
        Float ascent = this.getCachedValue(ASCENT, Float.class);
        if (ascent == null) {
            ascent = Float.valueOf(0.0f);
            for (TextFragment fragment : this) {
                float currentAscent = fragment.getFontDescriptor().getSize() * fragment.getFontDescriptor().getFont().getFontDescriptor().getAscent() / 1000.0f;
                ascent = Float.valueOf(Math.max(ascent.floatValue(), currentAscent));
            }
            this.setCachedValue(ASCENT, ascent);
        }
        return ascent.floatValue();
    }

    @Override
    public void drawText(PDPageContentStream contentStream, Position upperLeft, Alignment alignment, DrawListener drawListener) throws IOException {
        this.drawAligned(contentStream, upperLeft, alignment, this.getWidth(), drawListener);
    }

    public void drawAligned(PDPageContentStream contentStream, Position upperLeft, Alignment alignment, float availableLineWidth, DrawListener drawListener) throws IOException {
        contentStream.saveGraphicsState();
        contentStream.beginText();
        float x = upperLeft.getX();
        float y = upperLeft.getY() - this.getAscent();
        float offset = TextSequenceUtil.getOffset(this, availableLineWidth, alignment);
        CompatibilityHelper.setTextTranslation(contentStream, x += offset, y);
        float extraWordSpacing = 0.0f;
        if (alignment == Alignment.Justify && this.getNewLine() instanceof WrappingNewLine) {
            extraWordSpacing = (availableLineWidth - this.getWidth()) / (float)(this.styledTextList.size() - 1);
        }
        FontDescriptor lastFontDesc = null;
        float lastBaselineOffset = 0.0f;
        Color lastColor = null;
        float gap = 0.0f;
        for (StyledText styledText : this.styledTextList) {
            boolean moveBaseline;
            if (!styledText.getFontDescriptor().equals(lastFontDesc)) {
                lastFontDesc = styledText.getFontDescriptor();
                contentStream.setFont(lastFontDesc.getFont(), lastFontDesc.getSize());
            }
            if (!styledText.getColor().equals(lastColor)) {
                lastColor = styledText.getColor();
                contentStream.setNonStrokingColor(lastColor);
            }
            if (styledText.getLeftMargin() > 0.0f) {
                gap += styledText.getLeftMargin();
            }
            boolean bl = moveBaseline = styledText.getBaselineOffset() != lastBaselineOffset;
            if (moveBaseline || gap > 0.0f) {
                float baselineDelta = lastBaselineOffset - styledText.getBaselineOffset();
                lastBaselineOffset = styledText.getBaselineOffset();
                CompatibilityHelper.moveTextPosition(contentStream, gap, baselineDelta);
                x += gap;
            }
            if (styledText.getText().length() > 0) {
                CompatibilityHelper.showText(contentStream, styledText.getText());
            }
            if (drawListener != null) {
                float currentUpperLeft = y + styledText.getAsent();
                drawListener.drawn(styledText, new Position(x, currentUpperLeft), styledText.getWidthWithoutMargin(), styledText.getHeight());
            }
            x += styledText.getWidthWithoutMargin();
            gap = extraWordSpacing;
            if (!(styledText.getRightMargin() > 0.0f)) continue;
            gap += styledText.getRightMargin();
        }
        contentStream.endText();
        contentStream.restoreGraphicsState();
    }

    public String toString() {
        return "TextLine [styledText=" + this.styledTextList + ", newLine=" + this.newLine + "]";
    }

    private static class TextLineIterator
    implements Iterator<TextFragment> {
        private Iterator<StyledText> styledText;
        private NewLine newLine;

        public TextLineIterator(Iterator<StyledText> styledText, NewLine newLine) {
            this.styledText = styledText;
            this.newLine = newLine;
        }

        @Override
        public boolean hasNext() {
            return this.styledText.hasNext() || this.newLine != null;
        }

        @Override
        public TextFragment next() {
            TextFragment next = null;
            if (this.styledText.hasNext()) {
                next = this.styledText.next();
            } else if (this.newLine != null) {
                next = this.newLine;
                this.newLine = null;
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

