/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.text.annotations;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageXYZDestination;
import rst.pdfbox.layout.text.DrawContext;
import rst.pdfbox.layout.text.Position;
import rst.pdfbox.layout.text.annotations.Annotated;
import rst.pdfbox.layout.text.annotations.AnnotatedStyledText;
import rst.pdfbox.layout.text.annotations.AnnotationProcessor;
import rst.pdfbox.layout.text.annotations.Annotations;
import rst.pdfbox.layout.util.CompatibilityHelper;

public class HyperlinkAnnotationProcessor
implements AnnotationProcessor {
    private Map<String, PageAnchor> anchorMap = new HashMap<String, PageAnchor>();
    private Map<PDPage, List<Hyperlink>> linkMap = new HashMap<PDPage, List<Hyperlink>>();

    @Override
    public void annotatedObjectDrawn(Annotated drawnObject, DrawContext drawContext, Position upperLeft, float width, float height) throws IOException {
        if (!(drawnObject instanceof AnnotatedStyledText)) {
            return;
        }
        AnnotatedStyledText annotatedText = (AnnotatedStyledText)drawnObject;
        this.handleHyperlinkAnnotations(annotatedText, drawContext, upperLeft, width, height);
        this.handleAnchorAnnotations(annotatedText, drawContext, upperLeft);
    }

    protected void handleAnchorAnnotations(AnnotatedStyledText annotatedText, DrawContext drawContext, Position upperLeft) {
        Iterable<Annotations.AnchorAnnotation> anchorAnnotations = annotatedText.getAnnotationsOfType(Annotations.AnchorAnnotation.class);
        for (Annotations.AnchorAnnotation anchorAnnotation : anchorAnnotations) {
            this.anchorMap.put(anchorAnnotation.getAnchor(), new PageAnchor(drawContext.getCurrentPage(), upperLeft.getX(), upperLeft.getY()));
        }
    }

    protected void handleHyperlinkAnnotations(AnnotatedStyledText annotatedText, DrawContext drawContext, Position upperLeft, float width, float height) {
        Iterable<Annotations.HyperlinkAnnotation> hyperlinkAnnotations = annotatedText.getAnnotationsOfType(Annotations.HyperlinkAnnotation.class);
        for (Annotations.HyperlinkAnnotation hyperlinkAnnotation : hyperlinkAnnotations) {
            List<Hyperlink> links = this.linkMap.get(drawContext.getCurrentPage());
            if (links == null) {
                links = new ArrayList<Hyperlink>();
                this.linkMap.put(drawContext.getCurrentPage(), links);
            }
            PDRectangle bounds = new PDRectangle();
            bounds.setLowerLeftX(upperLeft.getX());
            bounds.setLowerLeftY(upperLeft.getY() - height);
            bounds.setUpperRightX(upperLeft.getX() + width);
            bounds.setUpperRightY(upperLeft.getY());
            links.add(new Hyperlink(bounds, annotatedText.getColor(), hyperlinkAnnotation.getLinkStyle(), hyperlinkAnnotation.getHyperlinkURI()));
        }
    }

    @Override
    public void beforePage(DrawContext drawContext) {
    }

    @Override
    public void afterPage(DrawContext drawContext) {
    }

    @Override
    public void afterRender(PDDocument document) throws IOException {
        for (Map.Entry<PDPage, List<Hyperlink>> entry : this.linkMap.entrySet()) {
            PDPage page = entry.getKey();
            List<Hyperlink> links = entry.getValue();
            for (Hyperlink hyperlink : links) {
                PDAnnotationLink pdLink = null;
                pdLink = hyperlink.getHyperlinkURI().startsWith("#") ? this.createGotoLink(hyperlink) : CompatibilityHelper.createLink(page, hyperlink.getRect(), hyperlink.getColor(), hyperlink.getLinkStyle(), hyperlink.getHyperlinkURI());
                page.getAnnotations().add(pdLink);
            }
        }
    }

    private PDAnnotationLink createGotoLink(Hyperlink hyperlink) {
        String anchor = hyperlink.getHyperlinkURI().substring(1);
        PageAnchor pageAnchor = this.anchorMap.get(anchor);
        if (pageAnchor == null) {
            throw new IllegalArgumentException(String.format("anchor named '%s' not found", anchor));
        }
        PDPageXYZDestination xyzDestination = new PDPageXYZDestination();
        xyzDestination.setPage(pageAnchor.getPage());
        xyzDestination.setLeft((int)pageAnchor.getX());
        xyzDestination.setTop((int)pageAnchor.getY());
        return CompatibilityHelper.createLink(pageAnchor.getPage(), hyperlink.getRect(), hyperlink.getColor(), hyperlink.getLinkStyle(), (PDDestination)xyzDestination);
    }

    private static class Hyperlink {
        private final PDRectangle rect;
        private final Color color;
        private final String hyperlinkUri;
        private final Annotations.HyperlinkAnnotation.LinkStyle linkStyle;

        public Hyperlink(PDRectangle rect, Color color, Annotations.HyperlinkAnnotation.LinkStyle linkStyle, String hyperlinkUri) {
            this.rect = rect;
            this.color = color;
            this.hyperlinkUri = hyperlinkUri;
            this.linkStyle = linkStyle;
        }

        public PDRectangle getRect() {
            return this.rect;
        }

        public Color getColor() {
            return this.color;
        }

        public String getHyperlinkURI() {
            return this.hyperlinkUri;
        }

        public Annotations.HyperlinkAnnotation.LinkStyle getLinkStyle() {
            return this.linkStyle;
        }

        public String toString() {
            return "Hyperlink [rect=" + this.rect + ", color=" + this.color + ", hyperlinkUri=" + this.hyperlinkUri + ", linkStyle=" + (Object)((Object)this.linkStyle) + "]";
        }
    }

    private static class PageAnchor {
        private final PDPage page;
        private final float x;
        private final float y;

        public PageAnchor(PDPage page, float x, float y) {
            this.page = page;
            this.x = x;
            this.y = y;
        }

        public PDPage getPage() {
            return this.page;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public String toString() {
            return "PageAnchor [page=" + this.page + ", x=" + this.x + ", y=" + this.y + "]";
        }
    }
}

