/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.util;

import rst.pdfbox.layout.util.Enumerator;

public class Enumerators {

    public static class RomanEnumerator
    implements Enumerator {
        private int count;

        public RomanEnumerator() {
            this(1);
        }

        public RomanEnumerator(int startCount) {
            this.count = startCount;
        }

        @Override
        public String next() {
            return this.toRoman(this.count++);
        }

        @Override
        public String getDefaultSeperator() {
            return ".";
        }

        private String toRoman(int input) {
            if (input < 1 || input > 3999) {
                return "Invalid Roman Number Value";
            }
            String s = "";
            while (input >= 1000) {
                s = s + "M";
                input -= 1000;
            }
            while (input >= 900) {
                s = s + "CM";
                input -= 900;
            }
            while (input >= 500) {
                s = s + "D";
                input -= 500;
            }
            while (input >= 400) {
                s = s + "CD";
                input -= 400;
            }
            while (input >= 100) {
                s = s + "C";
                input -= 100;
            }
            while (input >= 90) {
                s = s + "XC";
                input -= 90;
            }
            while (input >= 50) {
                s = s + "L";
                input -= 50;
            }
            while (input >= 40) {
                s = s + "XL";
                input -= 40;
            }
            while (input >= 10) {
                s = s + "X";
                input -= 10;
            }
            while (input >= 9) {
                s = s + "IX";
                input -= 9;
            }
            while (input >= 5) {
                s = s + "V";
                input -= 5;
            }
            while (input >= 4) {
                s = s + "IV";
                input -= 4;
            }
            while (input >= 1) {
                s = s + "I";
                --input;
            }
            return s;
        }
    }

    public static class LowerCaseRomanEnumerator
    extends RomanEnumerator {
        public LowerCaseRomanEnumerator() {
        }

        public LowerCaseRomanEnumerator(int startCount) {
            super(startCount);
        }

        @Override
        public String next() {
            return super.next().toLowerCase();
        }
    }

    public static class AlphabeticEnumerator
    implements Enumerator {
        static final char[] digits = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        private int count;

        public AlphabeticEnumerator() {
            this(1);
        }

        public AlphabeticEnumerator(int startCount) {
            this.count = startCount;
        }

        @Override
        public String next() {
            return AlphabeticEnumerator.toString(this.count++ - 1);
        }

        @Override
        public String getDefaultSeperator() {
            return ")";
        }

        private static String toString(int i) {
            char[] buf = new char[33];
            int charPos = 32;
            for (i = -i; i <= -digits.length; i /= digits.length) {
                buf[charPos--] = digits[-(i % digits.length)];
            }
            buf[charPos] = digits[-i];
            return new String(buf, charPos, 33 - charPos);
        }
    }

    public static class LowerCaseAlphabeticEnumerator
    extends AlphabeticEnumerator {
        public LowerCaseAlphabeticEnumerator() {
        }

        public LowerCaseAlphabeticEnumerator(int startCount) {
            super(startCount);
        }

        @Override
        public String next() {
            return super.next().toLowerCase();
        }
    }

    public static class ArabicEnumerator
    implements Enumerator {
        private int count;

        public ArabicEnumerator() {
            this(1);
        }

        public ArabicEnumerator(int startCount) {
            this.count = startCount;
        }

        @Override
        public String next() {
            return String.valueOf(this.count++);
        }

        @Override
        public String getDefaultSeperator() {
            return ".";
        }
    }
}

